/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileRedstonePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected FriendlyByteBuf buffer;

    public TileRedstonePacket() {
        super(3, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        Level world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IPacketHandlerTile) {
            IPacketHandlerTile handlerTile = (IPacketHandlerTile)tile;
            handlerTile.handleRedstonePacket(this.buffer);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
    }

    public static void sendToClient(IPacketHandlerTile tile) {
        if (tile.world() == null || Utils.isClientWorld(tile.world())) {
            return;
        }
        TileRedstonePacket packet = new TileRedstonePacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getRedstonePacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToAllAround(packet.pos, 192.0, (ResourceKey<Level>)tile.world().m_46472_());
    }
}

